<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class HmoPlhOrganisation extends Model 
{

    protected $table = 'hmo_plh_organisations';
    public $timestamps = true;
    protected $fillable = array('hmo_form_id', 'contact_name', 'organisation_name', 'telephone', 'email');

    public function hmoForm()
    {
        return $this->belongsTo('HmoForm', 'hmo_form_id');
    }

    public function organisationAddress()
    {
        return $this->morphOne('Address', 'addressable');
    }

}